<?php require("config.php"); include("inc/check_session.php");

$_TITLE = "Newsletter Subscribers";
$_TOPBAR = true;
$_SIDEBAR = true;

require("inc/header.php");
require("inc/widget_setting.php");
?>

<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-envelop mr-2"></i> <span class="font-weight-semibold"><?php _e( $_TITLE ); ?></span></h4>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<?php /*<div class="header-elements d-none">
			<div class="d-flex justify-content-center">
				<button id="add-new" class="btn btn-link btn-float text-default"><i class="icon-plus3 text-primary"></i><span>Add New</span></button>
			</div>
		</div>*/ ?>
	</div>

	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="index.php" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Home</a>
				<span class="breadcrumb-item active"><?php _e( $_TITLE ); ?></span>
			</div>
		</div>
	</div>
</div>

<div class="content">

	<?php if( isset($_GET['mess']) and !empty($_GET['mess']) ){ ?>
	<div class="alert text-violet-800 alpha-violet alert-dismissible">
		<button type="button" class="close" data-dismiss="alert"><span>×</span></button>
		<?php _e( $_GET['mess'] ); ?>
	</div>
	<?php } ?>

	<?php /*<div id="add-new-card" class="card" style="display:none;">
		<div class="card-header header-elements-inline">
			<h5 class="card-title">Add Widget Area</h5>
		</div>
		<div class="card-body">
				
			<form action="mini_process.php" method="post" enctype="multipart/form-data">

				<input type="hidden" name="p" value="AddWidgetArea">
				
				<div class="form-group row">
					<label for="name" class="col-form-label col-md-2">Name:</label>
					<div class="col-md-10">
						<input id="name" name="name" class="form-control" type="text" required>
					</div>
				</div>

				<div class="form-group row">
					<div class="col-md-2"></div>
					<div class="col-md-10"><button type="submit" id="edit" class="btn btn-primary"><i class="icon-floppy-disk mr-2"></i> Save</button></div>
				</div>

			</form>

		</div>
	</div>

	<div id="edit-card" class="card" style="display:none;">
		<div class="card-header header-elements-inline">
			<h5 class="card-title">Edit Widget Area</h5>
		</div>
		<div class="card-body">
				
			<form action="mini_process.php" method="post" enctype="multipart/form-data">

				<input type="hidden" name="p" value="UpdWidgetArea">
				<input id="edit_id" type="hidden" name="id" value="0">
				
				<div class="form-group row">
					<label for="edit_name" class="col-form-label col-md-2">Name:</label>
					<div class="col-md-10">
						<input id="edit_name" name="name" class="form-control" type="text" value="" required>
					</div>
				</div>

				<div class="form-group row">
					<div class="col-md-2"></div>
					<div class="col-md-10"><button type="submit" id="edit" class="btn btn-primary"><i class="icon-floppy-disk mr-2"></i> Save</button></div>
				</div>

			</form>

		</div>
	</div>*/ ?>

	<div class="card">

		<div class="card-body">
			Total of <?php $subscribers = db_result(db_query("SELECT count(*) FROM `subscribers`"),0); _e( appendzero($subscribers) ); ?> subscribers found!
		</div>

		<?php
		$subscribers_query = db_query("SELECT * FROM `subscribers`");
		if( db_num_rows($subscribers_query) > 0 ){
		?>
		<form id="bulkactionform" action="bulksubscribers.php" method="post">
		<div class="table-responsive">
			<table class="table table-striped table-hover">
				
				<thead>
					<tr>
						<th style="width:50px;"></th>
						<th>Email</th>
						<th class="text-center" style="width:150px;">Date</th>
					</tr>
				</thead>

				<tbody>
					
					<?php while($subscriber = db_fetch_array($subscribers_query)){ ?>
					<tr>

						<td align="center">
						    <input class="idRow" type="checkbox" name="bulksubscribers[]" value="<?php _e( $subscriber['id'] ); ?>">
						</td>
						
						<td>
							<span class="font-weight-bold"><?php _e( $subscriber['email'] ); ?></span>
						</td>
						
						<td class="text-center">
							<?php _e( date( "d M, Y", strtotime($subscriber['date']) ) ); ?>
						</td>

					</tr>
					<?php } ?>
					
					<tr id="bulk-wrapper" style="display:none;">
					    <td colspan="3">
					        <div>
					            <button type="submit" class="btn bg-pink-400" onclick="return confirm('Are you sure you want to delete?')">Delete Selected</button>
					        </div>
					    </td>
					</tr>

				</tbody>

			</table>
		</div>
		</form>
		
		<script>
		    $(document).ready(function(){
		        $('.idRow').on('click', function(){
		            if( $('input[name="bulksubscribers[]"]:checked').length > 0){
					    $("#bulk-wrapper").show("fast");
					}else{
					    $("#bulk-wrapper").hide("fast");
					}
					
		        });
		    });
		</script>
		
		<?php } ?>

	</div>

</div>

<?php require("inc/footer.php"); ?>